# 🤖 ServiceNow Gen AI Automation Analyzer

**For CIOs & CFOs:** Identify which enterprise applications to automate using Generative AI, with data-driven ROI calculations and executive recommendations.

This tool connects to your **ServiceNow CMDB**, analyzes your application portfolio using **OpenAI GPT-4** via a **LangGraph agent**, and generates comprehensive Excel reports with automation recommendations and ROI projections.

---

## ✨ Key Features

- 🔌 **ServiceNow Integration** - Reads business applications from `cmdb_ci_business_app`
- 🤖 **AI-Powered Analysis** - GPT-4 analyzes portfolio and provides intelligent recommendations
- 📊 **Executive Excel Reports** - 8-sheet report with AI insights, ROI, and implementation roadmap
- 💰 **ROI Calculations** - Annual savings, implementation costs, payback periods, 3-year NPV
- 🎯 **Prioritization** - Quick Wins vs Strategic vs Long-term automation opportunities

---

## 🚀 Quick Start

### Prerequisites
- Python 3.10+
- ServiceNow instance with API access
- OpenAI API key

### Step 1: Install Dependencies
```bash
cd servicenow_ai_analyzer
pip install -r requirements.txt
```

### Step 2: Configure Credentials
```bash
# Copy template to .env
copy env_template.txt .env
```

Edit `.env` with your credentials:
```env
# ServiceNow
SERVICENOW_INSTANCE_URL=https://your-instance.service-now.com
SERVICENOW_USERNAME=admin
SERVICENOW_PASSWORD=your_password

# OpenAI
OPENAI_API_KEY=sk-your-api-key
OPENAI_MODEL=gpt-4o

# Settings
USE_MOCK_DATA=false
```

### Step 3: Generate Mock Data (Optional)
If your ServiceNow is empty, generate 1000 sample enterprise apps:
```bash
python push_apps.py
```

### Step 4: Run Analysis
```bash
python run_full_analysis.py
```

**Output:** `output/AI_Automation_Analysis_YYYYMMDD_HHMMSS.xlsx`

---

## 📊 What's in the Excel Report?

| Sheet | Description |
|-------|-------------|
| **AI Insights** | GPT-4's executive recommendations and strategic analysis |
| **Executive Summary** | Portfolio overview, key metrics, top 5 quick wins |
| **Top 50 Recommendations** | Best automation candidates ranked by ROI |
| **Automation Candidates** | Apps with high automation scores (≥0.5) |
| **Category Analysis** | Savings potential by application category |
| **Department Analysis** | Analysis by business department with priorities |
| **Implementation Roadmap** | 3-phase plan: Quick Wins → Strategic → Enterprise |
| **Full Portfolio Data** | Complete dataset with filters for custom analysis |

---

## 🛠️ Commands

| Command | Description |
|---------|-------------|
| `python run_full_analysis.py` | **Full AI analysis + Excel report** |
| `python push_apps.py` | Push 1000 mock apps to ServiceNow |
| `python push_apps.py --clear` | Clear existing apps and repush |
| `python run_ai_analysis.py` | AI analysis only (console output) |
| `python report_generator.py` | Excel report only (no AI) |
| `python servicenow_client.py` | Test ServiceNow connection |
| `python config.py` | Verify configuration |

---

## 🔄 How It Works

```
┌────────────────────────────────────────────────────────────────────┐
│                         Analysis Flow                              │
├────────────────────────────────────────────────────────────────────┤
│                                                                    │
│   .env ─── credentials ───> Config                                │
│                                │                                   │
│                                ▼                                   │
│   ┌─────────────┐        ┌─────────────┐        ┌──────────────┐  │
│   │ ServiceNow  │──API──>│  LangGraph  │──AI───>│ Excel Report │  │
│   │    CMDB     │        │   Agent     │        │              │  │
│   │             │        │             │        │ • AI Insights│  │
│   │ 1000 Apps   │        │ GPT-4 +     │        │ • ROI Data   │  │
│   │             │        │ Tools       │        │ • Charts     │  │
│   └─────────────┘        └─────────────┘        └──────────────┘  │
│                                                                    │
└────────────────────────────────────────────────────────────────────┘
```

### LangGraph Agent Tools
The AI agent uses these tools to analyze your portfolio:
- `get_portfolio_summary` - Overall portfolio statistics
- `get_top_roi_opportunities` - Best ROI candidates
- `get_high_automation_candidates` - Apps with highest automation potential
- `get_applications_by_category` - Category-specific analysis
- `calculate_portfolio_automation_summary` - Aggregate savings calculations

---

## 📈 Sample Results

### Portfolio Summary
| Metric | Value |
|--------|-------|
| Applications Analyzed | 941 |
| Total Annual IT Spend | $2.3B |
| Potential Annual Savings | $72M+ |
| Overall Portfolio ROI | 48.4% |

### Top AI Recommendations
| Rank | Application | Automation Score | ROI | Annual Savings |
|------|-------------|------------------|-----|----------------|
| 1 | Privileged Access Manager | 93% | 44% | $159K |
| 2 | Business Process Automation | 85% | 45% | $239K |
| 3 | Know Your Customer Platform | 83% | 42% | $211K |

---

## 🏗️ Project Structure

```
servicenow_ai_analyzer/
├── .env                         # Credentials (create from template)
├── env_template.txt             # Template for .env
│
├── run_full_analysis.py         # Main: AI analysis + Excel report
├── run_ai_analysis.py           # AI analysis only
├── push_apps.py                 # Push mock apps to ServiceNow
│
├── agent.py                     # LangGraph AI agent
├── tools.py                     # LangChain tools for ServiceNow
├── servicenow_client.py         # ServiceNow API client
├── config.py                    # Configuration management
│
├── enhanced_report_generator.py # Excel report with AI insights
├── report_generator.py          # Basic Excel report
│
├── requirements.txt             # Python dependencies
└── data/
    └── mock_app_generator.py    # Generate 1000 mock apps
```

---

## ⚙️ Configuration Reference

| Environment Variable | Description | Default |
|---------------------|-------------|---------|
| `SERVICENOW_INSTANCE_URL` | ServiceNow instance URL | - |
| `SERVICENOW_USERNAME` | API username | admin |
| `SERVICENOW_PASSWORD` | API password | - |
| `OPENAI_API_KEY` | OpenAI API key | - |
| `OPENAI_MODEL` | GPT model | gpt-4o |
| `USE_MOCK_DATA` | Use local JSON instead of API | false |

---

## 🏦 Application Categories

Mock data includes 10 enterprise categories for financial services:

| Category | Example Applications |
|----------|---------------------|
| Trading & Markets | Algorithmic trading, FX platforms, order management |
| Risk & Compliance | AML, KYC, fraud detection, regulatory reporting |
| Core Banking | Payments, treasury, general ledger, wire transfers |
| Customer Relationship | Wealth management, client onboarding, CRM |
| Data & Analytics | BI platforms, data warehouse, reporting |
| Infrastructure & Security | IAM, SSO, security operations, encryption |
| Human Capital | HRIS, talent management, payroll, learning |
| Operations & Workflow | BPM, document management, procurement |
| Integration & API | ESB, API gateway, message queues |
| Finance & Accounting | AP/AR, financial close, tax, audit |

---

## 🔧 Troubleshooting

| Issue | Solution |
|-------|----------|
| `SERVICENOW_PASSWORD not set` | Check `.env` file exists and has password |
| `OPENAI_API_KEY not set` | Add your OpenAI key to `.env` |
| `Connection failed` | Verify ServiceNow URL and credentials |
| `No apps found` | Run `python push_apps.py` to create mock data |

---

## 📝 License

MIT License - Free to use for automation analysis.
